#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgSelectSpecificities;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	
	
	[TestFixture]
	public class BOL_RackLot : BaseTest 
	{

		private BOL.RackLot _tstRL;
		private DataTable _dtRackLot;
		private DataTable _dtRack;
		
		
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RL.*, RP.ReactivityPhaseText FROM RackLot RL JOIN ReactivityPhase RP ON RL.ReactivityPhaseCode = RP.ReactivityPhaseCode WHERE RL.RecordStatusCode = 'A' AND RL.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

			this._tstRL = new BOL.RackLot(this._dtRackLot.Rows[0]);
			this._tstRL.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.RackLot);
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.RackLot tmpRL = new BOL.RackLot();
			Assert.IsNotNull(tmpRL);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.RackLot tmpRL = new BOL.RackLot(this._dtRackLot.Rows[0]);

			Assert.IsNotNull(tmpRL);
			Assert.IsTrue(tmpRL.RackLotGuid == (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.RackLotGuid]);
			Assert.IsTrue(tmpRL.LotUseDate == (System.DateTime)this._dtRackLot.Rows[0][TABLES.RackLot.LotUseDate]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void RackLotGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstRL.RackLotGuid = tstValue;

			Assert.IsTrue(this._tstRL.RackLotGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackLotGuid_Fail()
		{
		}

		[Test]
		public void TestWithName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRL.TestWithName = tstValue;

			Assert.IsTrue(this._tstRL.TestWithName == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestWithName_Fail()
		{
		}

		[Test]
		public void ExpectedMinimumReactions_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRL.ExpectedMinimumReactions = tstValue;

			Assert.IsTrue(this._tstRL.ExpectedMinimumReactions == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExpectedMinimumReactions_Fail()
		{
		}

		[Test]
		public void ReactivityPhaseText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRL.ReactivityPhaseText = tstValue;

			Assert.IsTrue(this._tstRL.ReactivityPhaseText == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReactivityPhaseText_Fail()
		{
		}

		[Test]
		public void ReactivityPhaseCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRL.ReactivityPhaseCode = tstValue;

			Assert.IsTrue(this._tstRL.ReactivityPhaseCode == tstValue);
		}

		[Test]
		public void ReactivityPhaseCode_Fail()
		{
			this._tstRL.ReactivityPhaseCode = string.Empty;

			Assert.IsTrue(this._tstRL.IsRuleBroken(BROKEN.ReactivityPhaseCode));
		}

		[Test]
		public void SatisfactoryResultIndicator_Pass()
		{
			bool tstValue = (!this._tstRL.SatisfactoryResultIndicator);

			this._tstRL.SatisfactoryResultIndicator = tstValue;

			Assert.IsTrue(this._tstRL.SatisfactoryResultIndicator == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SatisfactoryResultIndicator_Fail()
		{
		}

		[Test]
		public void Rack_Pass()
		{
			BOL.Rack tstValue = new BOL.Rack();

			this._tstRL.Rack = tstValue;

			Assert.IsTrue(this._tstRL.Rack == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Rack_Fail()
		{
		}

		[Test]
		public void Reagent_Pass()
		{
			BOL.Reagent tstValue = new BOL.Reagent();

			this._tstRL.Reagent = tstValue;

			Assert.IsTrue(this._tstRL.Reagent == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Reagent_Fail()
		{
		}

		[Test]
		public void LotUseDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstRL.LotUseDate = tstValue;

			Assert.IsTrue(this._tstRL.LotUseDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LotUseDate_Fail()
		{
		}

		[Test]
		public void SaveRackTests_Pass()
		{
			DataTable dtRackTestResults = new DataTable();
			dtRackTestResults.Columns.Add("Insert", typeof(bool));
			dtRackTestResults.Columns.Add("TestWithReagent", typeof(bool));
			dtRackTestResults.Columns.Add("TestWithReagentGuid", typeof(Guid));
			dtRackTestResults.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			dtRackTestResults.Columns.Add("ReagentTypeName");
			dtRackTestResults.Columns.Add(TABLES.RackLot.TestWithId);
			dtRackTestResults.Columns.Add(TABLES.RackLot.TestWithName);
			dtRackTestResults.Columns.Add("SetVialId");
			dtRackTestResults.Columns.Add("ExpectedMinimumReactions");
			dtRackTestResults.Columns.Add("ReactivityPhaseText");
			dtRackTestResults.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode);
			dtRackTestResults.Columns.Add("IsResults");
			dtRackTestResults.Columns.Add("IatResults");
			dtRackTestResults.Columns.Add("CcResults");
			dtRackTestResults.Columns.Add("TestResultIndicator");
			dtRackTestResults.Columns.Add(TABLES.ReagentType.ReagentTypeId);
			dtRackTestResults.Columns.Add("ReadOnlyIsResults", typeof(Boolean));
			dtRackTestResults.Columns.Add("ReadOnlyIatResults", typeof(Boolean));
			dtRackTestResults.Columns.Add("ReadOnlyCcResults", typeof(Boolean));
			dtRackTestResults.Columns.Add(ARTIFICIAL.IndicatorMessage);
			dtRackTestResults.Columns.Add(TABLES.RackLot.TestingMethodCode, typeof(string));

			DataRow drRackTestResult = dtRackTestResults.NewRow();

			DataTable dtReagents = Reagent.GetReagents(UnitTestConfig.TestDivisionCode);

			drRackTestResult[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.RackLot.ReagentGuid];
			drRackTestResult["Insert"] = false;
			drRackTestResult["TestWithReagent"] = false;
			drRackTestResult["ReagentTypeName"] = "Anti-A";
			drRackTestResult[TABLES.RackLot.TestWithId] = 63;
			drRackTestResult[TABLES.RackLot.TestWithName] = "Screening Cells";
			drRackTestResult["SetVialId"] = "1";
			drRackTestResult["ExpectedMinimumReactions"] = "2";
			drRackTestResult["ReactivityPhaseText"] = ARTIFICIAL.IS;
			drRackTestResult[TABLES.ReactivityPhase.ReactivityPhaseCode] = "1";
			drRackTestResult["IsResults"] = "4";
			drRackTestResult["IatResults"] = "3";
			drRackTestResult["CcResults"] = "2";
			drRackTestResult["TestResultIndicator"] = "V";
			drRackTestResult[TABLES.ReagentType.ReagentTypeId] = "48";
			drRackTestResult["ReadOnlyIsResults"] = true;
			drRackTestResult["ReadOnlyIatResults"] = true;
			drRackTestResult["ReadOnlyCcResults"] = true;
			drRackTestResult[ARTIFICIAL.IndicatorMessage] = "Test Message";
			drRackTestResult[TABLES.RackLot.TestingMethodCode] = "T";

			dtRackTestResults.Rows.Add(drRackTestResult);
			Common.WorkloadProcessID [] workloadProcessIds = new Common.WorkloadProcessID[1];
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.DailyRackQualityControlQC);
			workloadProcessIds[0] = Common.WorkloadProcessID.DailyRackQualityControlQC;
			bool bResult = RackLot.SaveRackTests(dtRackTestResults, (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid], (byte[])this._dtRack.Rows[0][TABLES.Rack.RowVersion], false, UnitTestConfig.TestDivisionCode, Common.UpdateFunction.UnitTests, workloadProcessIds, "TestTech", System.DateTime.Now, System.DateTime.Now.AddHours(5), Guid.Empty);
			Assert.IsTrue(bResult == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveRackTests_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._tstRL.LoadDataRowFromThis(this._dtRackLot.NewRow());

			Assert.IsTrue((System.Guid)dr[TABLES.RackLot.RackLotGuid] == this._tstRL.RackLotGuid);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail()
		{
			DataRow dr = this._tstRL.LoadDataRowFromThis(new DataTable().NewRow());		
		}

		[Test]
		public void GetRackLotTableSchema_Pass()
		{
			DataTable dtTest = BOL.RackLot.GetRackLotTableSchema(true);

			Assert.IsTrue(dtTest.TableName == TABLES.RackLot.TableName);
			Assert.IsTrue(dtTest.Columns.Count == 13);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.RackGuid));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.TestWithName));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode));
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.RowVersion) == false);

			dtTest = BOL.RackLot.GetRackLotTableSchema(false);

			Assert.IsTrue(dtTest.TableName == TABLES.RackLot.TableName);
			Assert.IsTrue(dtTest.Columns.Count == 10);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.RackGuid) == false);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.TestWithName) == false);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions) == false);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode) == false);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.RackLot.RowVersion));

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRackLotTableSchema_Fail()
		{
		}


		[Test]
		public void IsReagentTestingPhaseCorrect_Pass()
		{
			System.Guid reagentGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.ReagentGuid];
			BOL.Reagent tmpR = new BOL.Reagent(reagentGuid);
			this._tstRL.Reagent = tmpR;

			bool retValue = this._tstRL.IsReagentTestingPhaseCorrect();
			Assert.IsTrue(retValue);
			//
			this._tstRL.ReactivityPhaseCode = ((int)Common.ReactivityPhase.All).ToString();
			retValue = this._tstRL.IsReagentTestingPhaseCorrect();
			Assert.IsTrue(!retValue);
		}

		[Test]
		public void IsReagentTestingPhaseCorrect_Fail()
		{
			System.Guid reagentGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.ReagentGuid];
			BOL.Reagent tmpR = new BOL.Reagent(reagentGuid);
			this._tstRL.Reagent = tmpR;

			this._tstRL.ReactivityPhaseCode = string.Empty;
			bool retValue = this._tstRL.IsReagentTestingPhaseCorrect();
			Assert.IsTrue(retValue);
		}

	}
}
#endif




